﻿  package{
	  import flash.display.*;
	  import flash.text.TextField;	  
	  import flash.text.TextFormat;
	  import flash.text.TextFormatAlign;
	  import flash.events.*;
	  import flash.geom.Rectangle;
	  import flash.geom.Point;
	  
	  public class DialogTemplates extends MovieClip{
		  
		  public var flag_hasStageEvent = false;	//if stage event found or not
		  public var noDragFlag:Boolean = false;
		  public var itemID:String = "";
		  public var dialogType:String = "edit";
		  
		  //inner elements:
		  //
		  //txt_caption
		  //input_name
		  //mc_buttonCancel
		  //mc_buttonUpdate
		  //mc_buttonClose
		  
		  //constructor
		  public function DialogTemplates(){
 			  this.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown_handler);
			  
			  this.txt_caption.mouseEnabled = false;
			  
			  CommonFunctions.initSimpleButton(this.mc_buttonCancel);
			  CommonFunctions.initSimpleButton(this.mc_buttonUpdate);
			  CommonFunctions.initSimpleButton(this.mc_buttonAdd);
			  CommonFunctions.initSimpleButton(this.mc_buttonSaveAsNew);
			  CommonFunctions.initSimpleButton(this.mc_buttonClose);
			  
			  this.mc_buttonCancel.addEventListener(MouseEvent.CLICK,onButtonCancelClick);
			  this.mc_buttonCancel.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  this.mc_buttonUpdate.addEventListener(MouseEvent.CLICK,onButtonUpdateClick);
			  this.mc_buttonUpdate.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);

			  this.mc_buttonAdd.addEventListener(MouseEvent.CLICK,onButtonAddClick);
			  this.mc_buttonAdd.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  this.mc_buttonSaveAsNew.addEventListener(MouseEvent.CLICK,onButtonSaveNewClick);
			  this.mc_buttonSaveAsNew.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);			  			  
			  
			  this.mc_buttonClose.addEventListener(MouseEvent.CLICK,onButtonCancelClick);
			  this.mc_buttonClose.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  //all buttons mouse down event
			  this.input_name.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  //keyboard events
			  this.input_name.addEventListener(KeyboardEvent.KEY_DOWN,onInputNameKeyDown);
		  }
		  		  
	      //-------------------------------------------------------------------------
		  // input box key down. exit edit mode, and save name
		  public function onInputNameKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 13:	//enter - update item and close dialog
					switch(this.dialogType){
						case "edit":
							updateItem();
							hide();
						break;
						case "add":
							addItem();
							hide();
						break;
						case "savenew":
							saveAsNew();
							hide();
						break;
						default:
							trace("unknown dialog type");
						break;
					}
				  break;
				  case 27:	//escape - close the dialog without updating
				  	hide();
				  break;
			  }
		  }
		  
		  //------------------------------------------------------------------
		  // descripttion keyboard down event. if esc clicked - hide the dialog
		  public function onInputDescKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 27:
				  	hide();
				  break;
			  }
		  }		  
		  
		  //------------------------------------------------------------------
		  // position the dialog to parent center
		  public function positionParentCenter(){			  	
			  	var website = this.parent;
				if(website == null) return(false);
				var centerPoint:Point = website.centerPoint;			
				
				this.x = centerPoint.x - Math.floor((this.width)/2);				
				this.y = centerPoint.y - Math.floor((this.height)/2)-50;
		  }
		  
		  //------------------------------------------------------------------
		  // mouse down handler. start drag the dialog.
		  private function mouseDown_handler(event:MouseEvent){
			  if(this.noDragFlag == true){
				  this.noDragFlag = false;
				  return(false);
			  }
			  
			  if(this.flag_hasStageEvent == false){		//add once stage mouseup event
				  stage.addEventListener(MouseEvent.MOUSE_UP,stageMouseUp_handler);
				  this.flag_hasStageEvent = true;
			  }			  
			  var website = this.parent;			  			  
			  if(website == null) this.startDrag(false);
			  else{		//bound the drag area of the dialog to the parent.
			  	var rect1:Rectangle = website.boundRect;
			  	var rect:Rectangle = new Rectangle(rect1.x,rect1.y,rect1.width-this.width,rect1.height-this.height);
				this.startDrag(false,rect);
			  }
		  }
		  
		  //------------------------------------------------------------------
		  //stage mouse up handler. stop dragging
		  private function stageMouseUp_handler(event:MouseEvent){
			  this.stopDrag();
		  }
		  
		  //------------------------------------------------------------------
		  //event on button mouse down. stop the dragging.
		  public function onButtonsMouseDown(event:MouseEvent){
			  this.noDragFlag = true;
		  }
		  		  
		  //------------------------------------------------------------------
		  //event on button ok click. hide the dialog, and move the parent ok event.
		  public function onButtonCancelClick(event:MouseEvent){
				hide();
		  }
		  
		  //------------------------------------------------------------------
		  //eventon button check link click. open link in a new window
		  public function onButtonCheckClick(event:MouseEvent){
			  trace("check link - open in a new window");
		  }
		  
		  //------------------------------------------------------------------
		  // move to the website update event.
		  public function updateItem(){
			  var exportPanel = this.parent;
			  exportPanel.updateTitle(itemID,this.input_name.text);
		  }
		  
		  //------------------------------------------------------------------
		  // add the item
		  public function addItem(){
			  var exportPanel = this.parent;
			  exportPanel.addTemplateDialogResponse(this.input_name.text);
		  }
		  
		  //------------------------------------------------------------------
		  // save as new item
		  public function saveAsNew(){
			  var exportPanel = this.parent;
			  exportPanel.saveNewTemplateDialogResponse(this.input_name.text);
		  }
		  
		  //------------------------------------------------------------------
		  
		  public function onButtonAddClick(event:MouseEvent){
			  addItem();
			  hide();
		  }
		  
		  //------------------------------------------------------------------
		  // save as new click
		  public function onButtonSaveNewClick(event:MouseEvent){
			  saveAsNew();
			  hide();
		  }
		  
		  //------------------------------------------------------------------
		  // hide all elements. for enabling only the nessessery
		  public function hideAllElemens(){
			  this.txt_saveNew.visible = false;
			  this.txt_editTemplate.visible = false;
			  this.txt_addTemplate.visible = false;
			  this.txt_caption.visible = false;
			  this.mc_buttonSaveAsNew.visible = false;
			  this.mc_buttonUpdate.visible = false;
			  this.mc_buttonAdd.visible = false;
		  }
		  
		  //------------------------------------------------------------------
		  // turn dialog to add type
		  public function toAddType(){
			  hideAllElemens();
			  this.txt_addTemplate.visible = true;
			  this.mc_buttonAdd.visible = true;
			  this.dialogType = "add";
		  }

		  //------------------------------------------------------------------
		  // turn dialog to save as type
		  public function toSaveAsType(){
			  hideAllElemens();
			  this.txt_saveNew.visible = true;
			  this.mc_buttonSaveAsNew.visible = true;
			  this.dialogType = "savenew";
		  }
		  
		  //------------------------------------------------------------------
		  // turn dialog to edit type
		  public function toEditType(strCaption:String){
			  hideAllElemens();
			  this.txt_editTemplate.visible = true;
			  this.txt_caption.visible = true;
			  this.mc_buttonUpdate.visible = true;
			  this.txt_caption.text = strCaption;
			  this.dialogType = "edit";
		  }
		  
		  //------------------------------------------------------------------
		  //event on button cancel click. hide the button
		  public function onButtonUpdateClick(event:MouseEvent){
			  updateItem();
			  hide();
		  }
		  
		  //------------------------------------------------------------------
		  //show the dialog with text
		  public function show(itemID:String,itemName:String){
			  this.itemID = itemID;
			  this.input_name.text = itemName;
			  positionParentCenter();
			  this.visible = true;
			  this.stage.focus = this.input_name;
		  }
		  
		  //------------------------------------------------------------------
		  //hide the dialog
		  public function hide(){
			  this.visible = false;
		  }
	  }   
  }